#!/bin/sh
##############################################################################
#                                                                            #
#              Script to uninstall SATO macOS Printer Driver                #
#                                                                            #
##############################################################################

#Stop CUPS system.
echo "Stop CUPS system."
sudo launchctl stop org.cups.cupsd

if [ -d "/Library/Printers/PPDs/Contents/Resources/en.lproj/" ];then
    #Remove the ppd files and the folder.
    sudo rm -rf /Library/Printers/PPDs/Contents/Resources/en.lproj/*
    sudo rm -rf /Library/Printers/PPDs/Contents/Resources/en.lproj/

    #Remove the ppd package.
    sudo pkgutil --forget com.sato.pkg.satodriver.ppd

    echo "[ OK ] Success to remove ppd files."
else
    echo "The ppd files are not installed."
fi

if [ -f "/usr/libexec/cups/filter/rastertosbpl" ];then
    #Remove the filter file.
    sudo rm -rf /usr/libexec/cups/filter/rastertosbpl

    #Remove the filter package.
    sudo pkgutil --forget com.sato.pkg.satodriver.rastertosbpl

    echo "[ OK ] Success to remove filter file."
else
    echo "The filter file is not installed."
fi

#Next, restart cups with:
echo "Restart CUPS system."
sudo launchctl start org.cups.cupsd

exit 0